const express = require('express');
const app = express();
const cors = require('cors');
const multer = require('multer');
const fs = require('fs');
const path = require('path');
const mysql = require('mysql');

// Configuração do diretório de uploads
const uploadDir = path.join(__dirname, '../public_html/uploads');
if (!fs.existsSync(uploadDir)) {
    fs.mkdirSync(uploadDir, { recursive: true });
}

// Configuração do Multer para salvar imagens
const storage = multer.diskStorage({
    destination: (req, file, cb) => cb(null, uploadDir),
    filename: (req, file, cb) => {
        const ext = path.extname(file.originalname) || '.jpg';
        cb(null, Date.now() + ext);
    },
});

const upload = multer({ storage });

app.use('/uploads', express.static(uploadDir)); // Servir arquivos estáticos

// Configuração do banco de dados
const db = mysql.createPool({

    host:"localhost",
    user:"root",
    password:"Karolinne102",
    database:"acsnoticia",
});

app.use(cors());
app.use(express.json());

require('dotenv').config();

const jwt = require('jsonwebtoken');

const verifyToken = (req, res, next) => {
    const token = req.headers.authorization?.split(" ")[1]; // Extrai o token

    if (!token) {
        return res.status(401).send("Token não fornecido.");
    }

    try {
        const decoded = jwt.verify(token, process.env.SECRET_KEY);
        req.user = decoded; // Adiciona os dados do usuário no objeto req
        next();
    } catch (err) {
        return res.status(403).send("Token inválido ou expirado.");
    }
};

// Função para inserir notícia
const inserirNoticia = (titulo, slug, data_noticia, descricao, exibir_home, id_usuario, nome_autor, foto_capa) => {
    return new Promise((resolve, reject) => {
        let SQL = 'INSERT INTO noticias (titulo, slug, data_noticia, descricao, exibir_na_home, id_usuario, nome_autor, foto_capa) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
        db.query(SQL, [titulo, slug, data_noticia, descricao, exibir_home, id_usuario, nome_autor, foto_capa], (err, result) => {
            if (err) {
                reject(err);
            } else {
                resolve(result.insertId);
            }
        });
    });
};

// Função para inserir imagens
const inserirImagens = (imagens, id_noticia) => {
    let SQLImagens = 'INSERT INTO fotos_noticia (id_noticia, foto) VALUES (?, ?)';

    let promises = imagens.map(imagem => {
        return new Promise((resolve, reject) => {
            db.query(SQLImagens, [id_noticia, imagem], (err, result) => {
                if (err) {
                    reject("Erro ao inserir imagem");
                } else {
                    resolve(result);
                }
            });
        });
    });

    return Promise.all(promises);
};

// Endpoint para cadastrar notícia
app.post("/cadastrarNoticia", upload.fields([{ name: 'foto_capa', maxCount: 1 }, { name: 'imagens', maxCount: 10 }]), (req, res) => {
    const { titulo, slug, data_noticia, descricao, exibir_home, id_usuario, nome_autor } = req.body;

    // Verifica se a foto de capa foi enviada
    if (!req.files['foto_capa']) {
        return res.status(400).json({ error: 'Foto de capa é obrigatória' });
    }

    // Processa a foto de capa
    const fotoCapaFile = req.files['foto_capa'][0];
    const fotoCapaUrl = `https://somosconexaosocial.org/uploads/${fotoCapaFile.filename}`;

    // Processa as imagens adicionais (se houver)
    const imagensUrls = req.files['imagens'] ? req.files['imagens'].map(file => `https://somosconexaosocial.org/uploads/${file.filename}`) : [];

    // Insere a notícia no banco de dados
    inserirNoticia(titulo, slug, data_noticia, descricao, exibir_home, id_usuario, nome_autor, fotoCapaUrl)
        .then(id_noticia => {
            // Insere as imagens adicionais no banco de dados
            return inserirImagens(imagensUrls, id_noticia);
        })
        .then(() => {
            res.json({ message: 'Notícia e imagens cadastradas com sucesso!' });
        })
        .catch(error => {
            console.error(error);
            res.status(500).json({ error: 'Erro ao cadastrar notícia' });
        });
});

// Iniciar o servidor
app.listen(3002, () => {
    console.log("Servidor de notícias rodando na porta 3002");
});


app.get("/", (req, res) => {
    res.send("retornando Graças a Deus")
});


app.post('/getUserLoginNoticias', (req, res) => {


    const { usuario, senha } = req.body;

    // Exemplo: Verifique o usuário e senha no banco (como você já faz)
    let SQL = "SELECT * FROM usuarios WHERE usuario = ?";

    db.query(SQL, [usuario ], (err, results) => {
        if (err) {
            console.error(err);
            return res.status(500).send("Erro no servidor");
        }

        if (results.length === 0 || results[0].senha !== senha) {
            return res.status(401).send("Usuário ou senha incorretos");
        }

        const user = results[0];

        // **Gerar o token JWT**
        const token = jwt.sign(
            { id: user.id_usuario },
            process.env.SECRET_KEY,
            { expiresIn: "3h" } // Token expira em 3 horas - quem fica tanto tempo
        );

        res.status(200).json({ token, user }); // Retorne o token e os dados do usuário
    });
});

// Token expira em 3 horas - quem fica tanto tempo - nao precisa carregar tudo, apesar que o principal em peso -- a foto e os outros dados - ja tao vindo agora



app.get("/getAllNoticiasById", verifyToken, (req, res) =>{

    // isso aqui vai listar as noticias com base no id do estagiario que esta consultando

    // essas são para os cards, vou selecionar apenas o nescessario para eles

    // depois eu vou mudar pra pegar so uma parte das noticias

    const { id } = req.query    

    let SQL= 'select id_noticia, titulo, slug, data_noticia, exibir_na_home, nome_autor, foto_capa from noticias where id_usuario = ? ORDER BY data_noticia DESC';

    db.query(SQL, [id], (err, result) => {

        if (err) {
            console.log(err);
            res.status(500).send("Erro ao consultar banco de dados");
        } else {
            
            res.send(result);
            
        }
    });

});


app.get("/checkSlugExists", verifyToken, (req, res) =>{

    const { slug } = req.query    

    let SQL= 'SELECT COUNT(*) AS total FROM noticias WHERE slug = ?';

    db.query(SQL, [slug], (err, result) => {

        if (err) {
            console.log(err);
            res.status(500).send("Erro ao consultar banco de dados");
        } else {           
            
            res.send(result);
            
        }
    });

});

app.get("/getAllNoticiasPro", verifyToken, (req, res) =>{

    // let SQL= 'select * from noticias where exibir_na_home = TRUE ORDER BY data_noticia DESC'; -- todas as noticias estruradas para aparecer as de destaque primeiro

    // depois eu vou mudar pra pegar so uma parte das noticias

    let SQL= 'SELECT id_noticia, titulo, slug, data_noticia, exibir_na_home, nome_autor, foto_capa FROM noticias ORDER BY exibir_na_home DESC, data_noticia DESC';

    db.query(SQL, (err, result) => {

        if (err) {
            console.log(err);
            res.status(500).send("Erro ao consultar banco de dados");
        } else {
            
            res.send(result);
            
        }
    });

});

app.get("/getNoticiaBySlug", verifyToken, (req, res) =>{

    const { slug } = req.query    

    let SQL= 'SELECT * FROM noticias WHERE slug = ?';

    db.query(SQL, [slug], (err, result) => {

        if (err) {
            console.log(err);
            res.status(500).send("Erro ao consultar banco de dados");
        } else {
            
            res.send(result);
            
        }
    });

});



// Função para inserir presenças


// Função para inserir imagens


// Endpoint para cadastrar a aula



app.get("/getAllFotosByIdNoticia", verifyToken, (req, res) =>{

    const { id } = req.query;

    let SQL= "SELECT * FROM fotos_noticia WHERE id_noticia = ?";

    db.query(SQL, [id], (err, result) => {

        if (err) {
            console.log(err);
            res.status(500).send("Erro ao consultar banco de dados");
        } else {
            
            res.send(result);
            
        }
    });

});

app.delete("/deleteFotoNoticiaById/:id", verifyToken, (req, res) => {

    const {id} = req.params;

    let SQL  = "delete from fotos_noticia where id_foto = ?";
    db.query(SQL, [id], (err, result) =>{

        if(err) console.log(err);
        else res.send(result);

    });



});

// vou criar um endpoint apenas para atualizar a foto de capa... ele vai ser chamado ou não, dependendo da variável que diz se ele foi alterado mesmo ou não





app.post("/inserirFotoNoticiaByIdAula", upload.single('imagem'), verifyToken, (req, res) => {    

    let { id_noticia } = req.body;

    let imagem = req.file;

    let SQL = 'INSERT INTO fotos_noticia (id_noticia, foto) VALUES (?, ?)';
   
    // Executando a consulta com parâmetros seguros
    db.query(SQL, [id_noticia, imagem.buffer], (err, result) => {
        
        if (err) {
            console.log(err);
            res.status(500).send("Erro ao consultar banco de dados");
        } else {
            
            res.send(result);
            
        }
    });
});


app.put("/alterarCoverNoticiaById", upload.single('imagem'), verifyToken, (req, res) => {    

    let { id_noticia } = req.body;

    let imagem = req.file;
    

    let SQL = "UPDATE noticias SET foto_capa = ? WHERE id_noticia = ?";   

    // Executando a consulta com parâmetros seguros
    db.query(SQL, [imagem.buffer, id_noticia], (err, result) => {
        
        if (err) {
            console.log(err);
            res.status(500).send("Erro ao consultar banco de dados");
        } else {
            
            res.send(result);       
            
        }
    });
});

app.put("/editarDadosNoticiaById", verifyToken, (req, res) => {    

    let { id_noticia, titulo, data_noticia, descricao, exibir_na_home } = req.body;    

    let SQL = "UPDATE noticias SET titulo = ?, data_noticia = ?, descricao  = ?, exibir_na_home = ? WHERE id_noticia = ?";   

    // Executando a consulta com parâmetros seguros
    db.query(SQL, [titulo, data_noticia, descricao, exibir_na_home, id_noticia], (err, result) => {
        
        if (err) {
            console.log(err);
            res.status(500).send("Erro ao consultar banco de dados");
        } else {
            
            res.send(result);       
            
        }
    });
});

app.delete("/deleteNoticiaById/:id", verifyToken, (req, res) => {

    const {id} = req.params;

    console.log(id);

    let SQL  = "delete from noticias where id_noticia = ?";
    db.query(SQL, [id], (err, result) =>{

        if(err) console.log(err);
        else res.send(result);

    });



});

app.get("/getAllNoticiasGeral", (req, res) =>{


    let SQL= 'select id_noticia, titulo, slug, data_noticia, exibir_na_home, nome_autor, foto_capa from noticias ORDER BY data_noticia DESC';

    db.query(SQL, (err, result) => {

        if (err) {
            console.log(err);
            res.status(500).send("Erro ao consultar banco de dados");
        } else {
            
            res.send(result);
            
        }
    });

});


app.get("/getAllFotosByIdNoticiaGeral", (req, res) =>{

    const { id } = req.query;

    let SQL= "SELECT * FROM fotos_noticia WHERE id_noticia = ?";

    db.query(SQL, [id], (err, result) => {

        if (err) {
            console.log(err);
            res.status(500).send("Erro ao consultar banco de dados");
        } else {
            
            res.send(result);
            
        }
    });

});

app.get("/getNoticiaGeralBySlug", (req, res) =>{

    const { slug } = req.query    

    let SQL= 'SELECT * FROM noticias WHERE slug = ?';

    db.query(SQL, [slug], (err, result) => {

        if (err) {
            console.log(err);
            res.status(500).send("Erro ao consultar banco de dados");
        } else {
            
            res.send(result);
            
        }
    });

});

app.get("/getNoticiasHomeGeral", (req, res) =>{


    let SQL= 'select id_noticia, titulo, slug, data_noticia, exibir_na_home, nome_autor, foto_capa from noticias where exibir_na_home = TRUE ORDER BY data_noticia DESC';

    db.query(SQL, (err, result) => {

        if (err) {
            console.log(err);
            res.status(500).send("Erro ao consultar banco de dados");
        } else {
            
            res.send(result);
            
        }
    });

});


// deletar daqui pra baixo

